#ifndef _SRCSTATE_H_
#define _SRCSTATE_H_

#include "AudioStack/AudioSources.h"
#include "AudioStack/clAudioSource.h"

#ifndef _DO_NOT_USE_BOSCH_OSAL_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
#include <stl_pif.h>
#else
#include <map>
#endif

namespace AudioStack
{


//class clAudioSource;

class clSrcState {
public:
   clSrcState(const tChar* pacName, AudioStates::enAudioStates enStateID);
   virtual ~clSrcState();

   typedef enum
   {
      On,
      Pause,
      Off,
      SrcAvailabilityChg
   } enTrigger;

   typedef enum {
      ENTRYCONDITION_NONE = 0,
      ENTRYCONDITION_INITIAL,
   } EEntryCondition;

   AudioStates::enAudioStates enGetStateID(){return m_enStateID;};

    static void vSetState(clAudioSource* pclAudioSource, clSrcState* pclState, tU32 u32UserData, tU8 enEntryCondition);
    static void vSetState(clAudioSource* pclAudioSource, clSrcState* pclState, tU32 u32UserData);
public:
    //Configurable Transitions
   virtual tVoid vSetTransition(enTrigger trigger, clSrcState* targetState);
   //Handle configured Transitions
   virtual tVoid vHandleTrigger(enTrigger trigger, clAudioSource* pclAudioSource, tU32 u32UserData);

   // transitions
   virtual void vEnter(clAudioSource* pclAudioSource, tU32 u32UserData, tU8 enEntryCondition);

   //message transitions
   virtual tVoid vMsg_On                (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_RequestConfirmed  (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_OnDone            (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_Off               (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_OffDone           (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_Pause             (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_PauseDone         (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_Init              (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_InitDone          (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_ServiceAvailable  (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_ServiceUnavailable(clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_WaitFor           (clAudioSource* src, tU32 u32UserData);
   virtual tVoid vMsg_SrcAvailabilityChg(clAudioSource* src, tU32 u32UserData);


   // members
   const tChar *m_pacName;          // state name for debug
   AudioStates::enAudioStates m_enStateID;
   tU32 m_u32UserData;

protected:
   bpstl::map<enTrigger, clSrcState* > m_transitionCollection;
   tBool m_bTrace;
};

}//namespace


#endif // _SRCSTATE_H_
